------------------------------------------------------------------------------------------
--
--	Glob_Var
--	========
--
--	Author: Ganesh Thadkamalla, Joseph Wilson 
--	Creation Date: 
--
--	Last Revised Date:  4 December 2002
--
--	Copyright (C) Oracle Services
--
--Description:  
--
------------------------------------------------------------------------------------------

create or replace package DW_glob_var IS
type ident_arr100 is table of varchar2(100) index by binary_integer;
empty  owa_util.ident_arr; 
empty100 ident_arr100;
/****************************************************************************
 The following serve as examples for the variables that need to be set for specific environment.
  lv_program_path varchar2(1000):= URL for web procedures.  Example: 'http://'||owa_util.get_cgi_env('SERVER_NAME')||owa_util.get_owa_service_path;
  lv_script_path varchar2(1000):= URL for storet.js, a javascript file. Example: 'http://everest.sdc-moses.com/storet/modern/scripts/storet.js';
  lv_image_path varchar2(1000):= URL for storet image files. Example: 'http://everest.sdc-moses.com/storet/modern/images/';
  lv_doc_path varchar2(1000):= URL for static html documents.  Example: 'http://everest.sdc-moses.com/storet/modern/doc/';
--file io directory for downloads
  lv_iodir varchar2(100):= physical directory path used for utl_file parameter.  Example: '/project/storet/modern/downloads';
  lv_download_path varchar2(200):= URL for above directory.  Example: 'http://everest.sdc-moses.com/storet/modern/downloads/';
--Report server path with key
  lv_report_key varchar2(200):= Report server URL and key. Example: 'http://everest.sdc-moses.com/storet/cgi-bin/rwcgi60s?storetmod';
-- where rwcgi60s is a shell script that sets cgi environment variables and calls Oracle's rwcgi60 executable.  storetmod is an entry in key mapping file. this key should have server=reportserver_name userid=storet_reports_username/password@connectstring %
*****************************************************************************/
--SDC UNIX everest/olympus paths.
  lv_program_path CONSTANT VARCHAR2(1000):= 'http://oasdev.sdc-moses.com/storet/srpp/';
--SDC environment path variables
  lv_script_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/modernit/scripts/DW_storet.js';
  lv_image_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/modernit/images/';
  lv_doc_path constant varchar2(1000):= 'http://everest.sdc-moses.com/storet/modernit/doc/';
--file io directory for downloads
  lv_iodir constant varchar2(100):='/project/storet/modern/downloads';
  lv_download_path constant varchar2(200):= 'http://everest.sdc-moses.com/storet/modern/downloads/';
--Report server path with key
  lv_report_key constant varchar2(200):='http://everest.sdc-moses.com/storet/cgi-bin/storetreports.sh?storetmod';
-- batch download pickup variable.
--Number of days the batch download files should be made availabe to user.
dl_savedays CONSTANT NUMBER(3):=14;
-- Simple Mail Transfer Protocal informatioin.
smtp_host CONSTANT VARCHAR2(200):= 'everest.sdc-moses.com';
smtp_port CONSTANT NUMBER :=25;
-- Activity count threshold value for submitting a download to batch process
dl_activity_batch_limit CONSTANT NUMBER:=200;
-- Station count threshold value for submitting a download to batch process
dl_station_batch_limit CONSTANT NUMBER:=100;
--EPA environment path variables
end; 
/
